// priority: 100
onEvent('block.registry', event => {
    //Dimensional shard block
    event.create('kubejsadditions:dimensional_shard_block')
        .material('stone')
        .hardness(2)
        .displayName('Dimensional Shard Block')
        .requiresTool(true)

    //Tesseract Frame
    //The Tesseract model and textures are owned and made by SuperMartijn642
    //https://www.curseforge.com/minecraft/mc-mods/tesseract
    //https://github.com/SuperMartijn642/Tesseract
    event.create('kubejsadditions:tesseract_frame').material('lantern').hardness(0.25).model('kubejsadditions:block/tesseract_frame').notSolid().redstoneConductor(false)
        .box(0, 0, 0, 3, 16, 3)
        .box(13, 0, 0, 16, 16, 3)
        .box(13, 0, 13, 16, 16, 16)
        .box(0, 0, 13, 3, 16, 16)
        .box(3, 0, 0, 13, 3, 3)
        .box(3, 13, 0, 13, 16, 3)
        .box(3, 0, 13, 13, 3, 16)
        .box(3, 13, 13, 13, 16, 16)
        .box(0, 0, 3, 3, 3, 13)
        .box(0, 13, 3, 3, 16, 13)
        .box(13, 0, 3, 16, 3, 13)
        .box(13, 13, 3, 16, 16, 13)

    //Tesseracted Plexiglass
    //Same thing as above
    event.create('kubejsadditions:tesseracted_plexiglass').material('metal').hardness(0.25).model('kubejsadditions:block/tesseracted_plexiglass').defaultTranslucent().lightLevel(1)

    //Clear Plexiglass
    event.create('kubejsadditions:clear_plexiglass')
            .material('glass')
            .hardness(0.5)
            .displayName('Clear Plexiglass')
            .requiresTool(true)
            .defaultTranslucent()

    //Colored Plexiglass
    global.dyes.forEach((dye) => {

        //Prepare the name variable, this will hold the name of the color
        let name = "";

        //Make the first letter a capital
        name += dye.charAt(0).toUpperCase();

        //For every letter inside the word representing the color
        for(let i = 1; i < dye.length; i++) {

            //If it's a dash, do special stuff
            if (dye.charAt(i) == '_'){
                //We will consider dashes as spaces for people to read properly
                name += ' '

                //Then check if we're still in the bounds of that color name, and if yes, add the next word's first letter as uppercase
                if (++i < dye.length){
                    name += dye.charAt(i).toUpperCase();
                }
            }
            else {
                //If it's not a dash then it's a viable character
                //There's only dashes and letters in the dyes array
                name += dye.charAt(i);
            }
        }
        //^ Effectively here we've transformed "white" into "White", "light_blue" into "Light Blue".

        //Create the blocks
        event.create('kubejsadditions:' + dye + '_plexiglass')
            .material('glass')
            .hardness(0.5)
            .displayName(name + ' Plexiglass')
            .requiresTool(true)
            .defaultTranslucent()
    });
})